/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.model.utils;

import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.model.utils.ModelUtils;
import crystalspider.justverticalslabs.model.utils.VertexUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class BakedQuadUtils {
    public static final List<BakedQuad> getReferredBakedQuads(BlockState referredState, Direction side, @Nonnull RandomSource rand, @Nonnull ModelData modelData, @Nullable RenderType renderType) {
        BakedModel referredBakedModel = ModelUtils.getReferredBakedModel(referredState);
        ModelData referredModelData = ModelUtils.getReferredModelData(referredState, modelData);
        ArrayList<BakedQuad> referredBakedQuads = new ArrayList<BakedQuad>(referredBakedModel.getQuads(referredState, side, rand, referredModelData, renderType));
        for (BakedQuad referredBakedQuad : referredBakedModel.getQuads(referredState, null, rand, referredModelData, renderType)) {
            if (referredBakedQuad.m_111306_() != side) continue;
            referredBakedQuads.add(referredBakedQuad);
        }
        if (referredBakedQuads.size() == 0) {
            JustVerticalSlabsLoader.LOGGER.warn("Referred Block has no texture for " + side + " face. No texture will be generated for that face.");
        }
        return referredBakedQuads;
    }

    public static final BakedQuad getNewBakedQuad(BakedQuad jsonBakedQuad, BakedQuad referredBakedQuad, Direction orientation) {
        return new BakedQuad(VertexUtils.updateVertices(jsonBakedQuad.m_111303_(), referredBakedQuad.m_111303_(), jsonBakedQuad.m_173410_(), referredBakedQuad.m_173410_(), orientation == Direction.UP), referredBakedQuad.m_111305_(), orientation, referredBakedQuad.m_173410_(), jsonBakedQuad.m_111307_());
    }
}

